/*
 * Decompiled with CFR 0.152.
 */
package common.config.tools.config.loader.properties;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.google.common.io.LineProcessor;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesLoader2 {
    private static final Logger logger = LoggerFactory.getLogger(PropertiesLoader2.class);
    private static final String FILE_CODING = "utf-8";

    public static Map<String, String> loader(File file) throws IOException {
        logger.info("Load File:[{}]", (Object)file.getAbsoluteFile());
        Map resultMap = (Map)Files.readLines((File)file, (Charset)Charset.forName(FILE_CODING), (LineProcessor)new LineProcessor<Map<String, String>>(){
            Map<String, String> resultMap = Maps.newLinkedHashMap();

            public boolean processLine(String line) throws IOException {
                int pos;
                if (!Strings.isNullOrEmpty((String)line) && !line.startsWith("#") && (pos = line.indexOf("=")) != -1) {
                    String key = Strings.nullToEmpty((String)line.substring(0, pos)).trim();
                    String value = Strings.nullToEmpty((String)line.substring(pos + 1).trim());
                    this.resultMap.put(key, value);
                    logger.info("Load properties: [{}={}]", (Object)key, (Object)value);
                }
                return true;
            }

            public Map<String, String> getResult() {
                return this.resultMap;
            }
        });
        return resultMap;
    }
}

