/*
 * Decompiled with CFR 0.152.
 */
package common.config.tools.config;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import common.config.tools.config.AbstractConfigTools;
import common.config.tools.file.monitor.FileMonitor;
import common.config.tools.file.monitor.IFileChangeListener;
import common.config.tools.file.monitor.PropertyFileListener;
import java.io.File;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigTools2
extends AbstractConfigTools {
    private static final Logger logger = LoggerFactory.getLogger(ConfigTools2.class);

    public static void load(Set<String> paths, Set<String> extensionSet) {
        ConfigTools2.load(paths, extensionSet, interval, true, (IFileChangeListener)new PropertyFileListener(false, configMap));
    }

    public static void load(String path, Set<String> extensionSet) {
        if (extensionSet == null || extensionSet.size() == 0) {
            extensionSet = ImmutableSet.of((Object)"config", (Object)"properties");
        }
        Set<Object> configRoot = Sets.newHashSet();
        configRoot = Strings.isNullOrEmpty((String)path) ? ConfigTools2.getDefaultPath() : Sets.newHashSet((Object[])new String[]{path});
        ConfigTools2.load(configRoot, (Set<String>)extensionSet);
    }

    public static void load(String path) {
        ConfigTools2.load(path, null);
    }

    public static void load() {
        ConfigTools2.load(null);
    }

    public static void load(Set<String> paths, Set<String> extensionSet, long interval, boolean recursive, IFileChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener is required.");
        }
        FileMonitor fileMonitor = new FileMonitor(interval);
        paths.forEach(path -> fileMonitor.addDirectoryListener((String)path, extensionSet, listener, true));
        fileMonitor.start();
    }

    public static void load(String path, long interval, boolean recursive, IOFileFilter filter, IFileChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener is required.");
        }
        FileMonitor fileMonitor = new FileMonitor(interval);
        fileMonitor.addDirectoryListener(path, filter, listener, true);
        fileMonitor.start();
    }

    public static void loadJson(Set<String> paths, long interval, boolean recursive, IFileChangeListener listener) {
        ConfigTools2.load(paths, (Set<String>)ImmutableSet.of((Object)"json"), interval, recursive, listener);
    }

    public static void loadJson(String paths, long interval, boolean recursive, IFileChangeListener listener) {
        ConfigTools2.loadJson((Set<String>)ImmutableSet.of((Object)paths), interval, recursive, listener);
    }

    @Deprecated
    public static void loadProperty(Set<String> paths, long interval, boolean recursive, IFileChangeListener listener) {
        ConfigTools2.load(paths, (Set<String>)ImmutableSet.of((Object)"config", (Object)"properties"), interval, recursive, listener);
    }

    private static Set<String> getDefaultPath() {
        LinkedHashSet defPathSet = Sets.newLinkedHashSet();
        defPathSet.add(ConfigTools2.getUserHomeConfigPath());
        defPathSet.add("config");
        return defPathSet;
    }

    private static String getUserHomeConfigPath() {
        String defPath = System.getProperty("user.home");
        if (Strings.isNullOrEmpty((String)defPath)) {
            defPath = "config";
        } else {
            if (!defPath.endsWith(File.separator)) {
                defPath = defPath + File.separator;
            }
            defPath = defPath + "config_tool" + File.separator + "config";
        }
        return defPath;
    }
}

