package common.config.tools.data;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;
import java.util.Map;

public interface IDataChangeListener<T> {
    static final Logger logger = LoggerFactory.getLogger(IDataChangeListener.class);

    /**
     * Query config data
     *
     * @return
     */
    List<T> queryData(long lmt);

    /**
     * Process config data object
     *
     * @param object
     */
    void processData(T object, Map<String, String> properties);
}
