package common.config.tools.data;

import com.google.common.base.Strings;
import common.config.tools.data.model.PropertyDataObject;


import java.util.Map;

public interface IPropertyDataListener extends IDataChangeListener<PropertyDataObject> {
    @Override
    default void processData(PropertyDataObject object, Map<String, String> properties) {

        String v = Strings.nullToEmpty(properties.get(object.getKey()));
        if (object.getStatus() == 0) {
            if (!Strings.isNullOrEmpty(v)) {
                properties.remove(object.getKey());
                logger.info("[DataLoader][delete][{}]=[{}]", object.getKey(), object.getValue());
            }
        } else {
            properties.put(object.getKey(), object.getValue());
            logger.info("[DataLoader][Update][{}]=[{}->{}]", object.getKey(), v, object.getValue());
        }

    }
}
