package common.config.tools.file.monitor;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Maps;
import common.config.tools.config.loader.json.JsonSerialize;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.File;
import java.util.Map;

/**
 * Created by Frank.Huang on 2017/5/9.
 */
public class JsonChangeListener extends FileChangeListenerAdaptor {
    private static final Logger logger = LoggerFactory.getLogger(JsonChangeListener.class);

    private Map<String, TypeReference> fileType = Maps.newHashMap();
    private Map<String, Object> fileValue = Maps.newHashMap();

    public JsonChangeListener(boolean backupAfterProcess,
                              Map<String, TypeReference> fileType,
                              Map<String, Object> fileValue) {
        super(backupAfterProcess);

        this.fileType = fileType;
        this.fileValue = fileValue;
    }

    @Override
    public void onFileCreate(File file) {
        loadJson(file);
    }


    @Override
    public void onFileChange(File file) {
        loadJson(file);
    }

    @Override
    public void onFileDelete(File file) {
        //super.onFileDelete(file);
    }

    public void loadJson(File file) {
        String fn = FilenameUtils.getName(file.getName());
        if (!fileType.containsKey(fn)) {
            logger.info("File[{}] not listener");
            return;
        }

        TypeReference typeReference = fileType.get(fn);
        Object v = JsonSerialize.loadJson(file, typeReference);
        if (v != null) {
            fileValue.put(fn, v);
            logger.info("Load json file[{}]", file.getAbsolutePath());
        } else {
            logger.info("Load json file[{}] may be error", file.getAbsolutePath());
        }
    }
}
