/*
 * Decompiled with CFR 0.152.
 */
package common.config.tools.config;

import com.google.common.base.Strings;
import common.config.tools.config.AbstractConfigData;
import common.config.tools.data.DataChangeListener;
import common.config.tools.data.I18nTools;
import common.config.tools.data.II18nDataListener;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class I18nConfigTools
extends AbstractConfigData {
    private static final Logger logger = LoggerFactory.getLogger(I18nConfigTools.class);

    public static void loadData(II18nDataListener iDataChangeLister) {
        DataChangeListener listener = new DataChangeListener(interval, configMap, Objects.requireNonNull(iDataChangeLister, "DataChangeLister is NULL"));
        scheduledThreadPool.scheduleAtFixedRate(listener, 0L, listener.getQueryInterval(), TimeUnit.MILLISECONDS);
    }

    public static String getI18nString(String lang, String key) {
        String enKey = I18nTools.buildI18nKey(lang, key);
        String value = (String)configMap.get(enKey);
        if (Objects.isNull(value) && !I18nTools.isLangEN(lang)) {
            enKey = I18nTools.buildI18nKey("en", key);
            value = (String)configMap.get(enKey);
        }
        return Strings.nullToEmpty((String)value);
    }

    public static String getI18nErrorMsg(String lang, int retCode, int errorCode) {
        return I18nConfigTools.getI18nString(lang, String.format("%s.%s", retCode, errorCode));
    }
}

