/*
 * Decompiled with CFR 0.152.
 */
package common.config.tools.file.monitor;

import com.google.common.collect.Maps;
import common.config.tools.config.loader.properties.PropertiesLoader2;
import common.config.tools.file.monitor.FileChangeListenerAdaptor;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyFileListener
extends FileChangeListenerAdaptor {
    private static final Logger logger = LoggerFactory.getLogger(PropertyFileListener.class);
    private Map<String, String> properties = Maps.newLinkedHashMap();

    public PropertyFileListener(boolean backupAfterProcess, Map<String, String> properties) {
        super(backupAfterProcess);
        this.properties = properties;
    }

    @Override
    public void onFileCreate(File file) {
        logger.info("Property Config File Create:[{}]", (Object)file.getAbsolutePath());
        this.loadProperty(file);
    }

    @Override
    public void onFileChange(File file) {
        logger.info("Property Config File Changed:[{}]", (Object)file.getAbsolutePath());
        this.loadProperty(file);
    }

    public void onFileDelete(File file) {
        logger.info("Property Config File Delete:[{}]", (Object)file.getAbsolutePath());
    }

    private void loadProperty(File file) {
        try {
            Map<String, String> propertyMap = PropertiesLoader2.loader(file);
            propertyMap.forEach((k, v) -> {
                if (this.properties.containsKey(k)) {
                    String oldValue = this.properties.get(k);
                    if (!oldValue.contentEquals((CharSequence)v)) {
                        this.properties.put((String)k, (String)v);
                        logger.info("property modify:key[{}] value[{}]->[{}]", new Object[]{k, oldValue, v});
                    }
                } else {
                    logger.info("property load:key[{}] value[{}]", k, v);
                    this.properties.put((String)k, (String)v);
                }
            });
        }
        catch (IOException e) {
            logger.info("Load properties[{}] exception:{}", (Object)file.getAbsolutePath(), (Object)e);
        }
    }
}

