package common.config.tools.config;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import common.config.tools.data.DataChangeListener;
import common.config.tools.data.I18nTools;
import common.config.tools.data.IDataChangeListener;
import common.config.tools.file.monitor.PathFileMonitor;
import common.config.tools.file.monitor.PropertyFileListener;

import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;

/**
 * Created by Frank.Huang on 2017/7/6.
 */
public class ConfigTools3 extends ConfigTools2 {

    public static void load(String filePath, String fileNamePattern, Set<String> extSet, final boolean recursive) {
        new PathFileMonitor(interval)
                .monitorPath(replaceDirectoryPath(filePath), fileNamePattern, extSet, new PropertyFileListener(false, configMap), recursive)
                .start();

    }

    public static void load(String dir, Set<String> extSet) {
        load(dir, null, extSet, true);
    }

    public static void load(String dir) {
        load(dir, null, ImmutableSet.of("config", "properties"), true);
    }

    public static void load() {
        load("config");
    }

//    /**
//     * 从外部加载数据：例如配置中心/DB
//     *
//     * @param iDataChangeLister:外部数据变更数据
//     */
//    public static void loadData(IDataChangeListener iDataChangeLister) {
//        Runnable runnable = new DataChangeListener(interval, configMap, Objects.requireNonNull(iDataChangeLister, "DataChangeLister is NULL"));
//        new Thread(runnable, "IPropertyDataListener").start();
//    }

    /**
     * Load external data
     *
     * @param iDataChangeLister:Load external data change listener
     */
    public static void loadData(IDataChangeListener iDataChangeLister) {
        DataChangeListener listener = new DataChangeListener(interval, configMap, Objects.requireNonNull(iDataChangeLister, "DataChangeLister is NULL"));
        scheduledThreadPool.scheduleAtFixedRate(listener, 0, listener.getQueryInterval(), TimeUnit.MILLISECONDS);
    }

    /**
     * Get i18n config value
     *
     * @param lang
     * @param key
     * @return
     */
    public static String getI18nString(String lang, String key) {
        String enKey = I18nTools.buildI18nKey(lang, key);
        String value = configMap.get(enKey);
        if (Objects.isNull(value)) {
            if (!I18nTools.isLangEN(lang)) {
                enKey = I18nTools.buildI18nKey(I18nTools.LANG_EN, key);
                value = configMap.get(enKey);
            }
        }

        return Strings.nullToEmpty(value);
    }
}
