package common.config.tools.data;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;
import java.util.Map;
import java.util.Objects;

public class DataChangeListener implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(DataChangeListener.class);
    private long lmt = 0;
    private long queryInterval;
    private IDataChangeListener iChangeLister;
    private Map<String, String> properties;

    public DataChangeListener(long queryInterval, Map<String, String> properties, IDataChangeListener iChangeLister) {
        this.queryInterval = queryInterval;
        this.iChangeLister = iChangeLister;
        this.properties = properties;
    }

    public long getQueryInterval() {
        return queryInterval;
    }

    @Override
    public void run() {
        long cmt = System.currentTimeMillis();
        if (cmt - lmt >= queryInterval) {
            List dataObjects = iChangeLister.queryData(lmt);
            if (Objects.nonNull(dataObjects)) {
                dataObjects.forEach(e -> {
                    if (e instanceof IPropertyData){
                        iChangeLister.processData((IPropertyData) e, properties);
                    }
                });
            }
            lmt = cmt;
        }
    }
}
