package common.config.tools.file.monitor;

import com.google.common.collect.Maps;
import common.config.tools.config.loader.properties.PropertiesLoader2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.File;
import java.io.IOException;
import java.util.Map;


/**
 * Created by Frank.Huang on 2017/5/4.
 */
public class PropertyFileListener extends FileChangeListenerAdaptor {

    private static final Logger logger = LoggerFactory.getLogger(PropertyFileListener.class);
    private Map<String, String> properties = Maps.newLinkedHashMap();

    public PropertyFileListener(boolean backupAfterProcess, Map<String, String> properties) {
        super(backupAfterProcess);
        this.properties = properties;
    }

    @Override
    public void onFileCreate(File file) {
        logger.info("Property Config File Create:[{}]", file.getAbsolutePath());
        loadProperty(file);
    }

    @Override
    public void onFileChange(File file) {
        logger.info("Property Config File Changed:[{}]", file.getAbsolutePath());
        loadProperty(file);
    }

    @Override
    public void onFileDelete(File file) {
        logger.info("Property Config File Delete:[{}]", file.getAbsolutePath());
    }

    private void loadProperty(File file) {
        try {
            Map<String, String> propertyMap = PropertiesLoader2.loader(file);
            propertyMap.forEach((k, v) -> {
                if (properties.containsKey(k)) {
                    String oldValue = properties.get(k);
                    if (!oldValue.contentEquals(v)) {
                        properties.put(k, v);
                        logger.info("property modify:key[{}] value[{}]->[{}]", k, oldValue, v);
                    }
                } else {
                    logger.info("property load:key[{}] value[{}]", k, v);
                    properties.put(k, v);
                }
            });
        } catch (IOException e) {
            logger.info("Load properties[{}] exception:{}", file.getAbsolutePath(), e);
        }
    }
}
