/*
 * Decompiled with CFR 0.152.
 */
package common.config.tools.config;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import common.config.tools.config.ConfigTools2;
import common.config.tools.data.DataChangeListener;
import common.config.tools.data.I18nTools;
import common.config.tools.data.IDataChangeListener;
import common.config.tools.file.monitor.PathFileMonitor;
import common.config.tools.file.monitor.PropertyFileListener;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class ConfigTools3
extends ConfigTools2 {
    public static void load(String filePath, String fileNamePattern, Set<String> extSet, boolean recursive) {
        new PathFileMonitor(interval).monitorPath(ConfigTools3.replaceDirectoryPath(filePath), fileNamePattern, extSet, new PropertyFileListener(false, configMap), recursive).start();
    }

    public static void load(String dir, Set<String> extSet) {
        ConfigTools3.load(dir, null, extSet, true);
    }

    public static void load(String dir) {
        ConfigTools3.load(dir, null, (Set<String>)ImmutableSet.of((Object)"config", (Object)"properties"), true);
    }

    public static void load() {
        ConfigTools3.load("config");
    }

    public static void loadData(IDataChangeListener iDataChangeLister) {
        DataChangeListener listener = new DataChangeListener(interval, configMap, Objects.requireNonNull(iDataChangeLister, "DataChangeLister is NULL"));
        scheduledThreadPool.scheduleAtFixedRate(listener, 0L, listener.getQueryInterval(), TimeUnit.MILLISECONDS);
    }

    public static String getI18nString(String lang, String key) {
        String enKey = I18nTools.buildI18nKey(lang, key);
        String value = (String)configMap.get(enKey);
        if (Objects.isNull(value) && !I18nTools.isLangEN(lang)) {
            enKey = I18nTools.buildI18nKey("en", key);
            value = (String)configMap.get(enKey);
        }
        return Strings.nullToEmpty((String)value);
    }
}

