/*
 * Decompiled with CFR 0.152.
 */
package common.config.tools.file.monitor;

import common.config.tools.file.monitor.IFileChangedFilter;
import java.io.File;
import java.util.regex.Pattern;
import org.apache.commons.io.filefilter.AbstractFileFilter;

public class FileNameFilter
extends AbstractFileFilter
implements IFileChangedFilter {
    protected String fnp;

    public FileNameFilter(String fn) {
        this.fnp = fn;
    }

    public boolean accept(File file) {
        if (!file.isFile()) {
            return false;
        }
        return this.accept(this.fnp, file.getName());
    }

    public boolean accept(File dir, String name) {
        return this.accept(this.fnp, name);
    }

    public boolean accept(String fnp, String fn) {
        fnp = fnp.replace('.', '#');
        fnp = fnp.replaceAll("#", "\\\\.");
        fnp = fnp.replace('*', '#');
        fnp = fnp.replaceAll("#", ".*");
        fnp = fnp.replace('?', '#');
        fnp = fnp.replaceAll("#", ".?");
        fnp = "^" + fnp + "$";
        Pattern p = Pattern.compile(fnp);
        return p.matcher(fn).matches();
    }
}

