package common.config.tools.config;

import com.google.common.base.Strings;
import common.config.tools.config.listener.IConfigChangeListener;
import common.config.tools.config.loader.ConfigToolsConfigLoader;
import common.config.tools.data.DataChangeListener;
import common.config.tools.data.I18nTools;
import common.config.tools.data.IDataChangeListener;
import common.config.tools.file.monitor.PathFileMonitor;
import common.config.tools.file.monitor.PropertyFileListener;
import common.config.tools.model.ConfigValueDTO;

import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;

/**
 * Created by Frank.Huang on 2017/7/6.
 */
public class ConfigTools3 extends AbstractConfigTools {
    @Deprecated
    public static void load(String filePath, String fileNamePattern, Set<String> extSet, final boolean recursive) {
        new PathFileMonitor(interval)
                .monitorPath(replaceDirectoryPath(filePath), fileNamePattern, extSet, new PropertyFileListener(false, configMap), recursive)
                .start();

    }

    @Deprecated
    public static void load(String dir, Set<String> extSet) {
        load(dir, null, extSet, true);
    }

    /**
     * @param dir      指定初始路径或文件
     * @param listener 配置工具初始化路径与监听回调
     */
    public static void load(String dir, IConfigChangeListener listener) {
        new ConfigRouteTools().loadConfig(ConfigToolsConfigLoader.getConfigObj(replaceDirectoryPath(dir)), listener);
    }

    /**
     * @param dir 指定初始路径或文件
     *            此方法兼容前版config-tools,仅需替换工具包,代码可无修改  v4.0.0  /20.12.15
     */
    public static void load(String dir) {
        new ConfigRouteTools().loadConfig(ConfigToolsConfigLoader.getConfigObj(replaceDirectoryPath(dir)), null);
    }

    /**
     * 默认以本地config文件夹启动
     * 此方法兼容前版config-tools,仅需替换工具包,代码可无修改启动  v4.0.0  /20.12.3
     */
    public static void load() {
        load(null);
    }

    /**
     * Load external data
     *
     * @param iDataChangeLister:Load external data change listener
     */
    @Deprecated
    public static void loadData(IDataChangeListener iDataChangeLister) {
        DataChangeListener listener = new DataChangeListener(interval, configMap, Objects.requireNonNull(iDataChangeLister, "DataChangeLister is NULL"));
        scheduledThreadPool.scheduleAtFixedRate(listener, 0, listener.getQueryInterval(), TimeUnit.MILLISECONDS);
    }

    /**
     * Get i18n config value
     *
     * @param lang
     * @param key
     * @return
     */
    public static String getI18nString(String lang, String key) {
        String enKey = I18nTools.buildI18nKey(lang, key);
        ConfigValueDTO valueDTO = configMap.get(enKey);
        if (Objects.isNull(valueDTO)) {
            if (!I18nTools.isLangEN(lang)) {
                enKey = I18nTools.buildI18nKey(I18nTools.LANG_EN, key);
                valueDTO = configMap.get(enKey);
            }
        }

        return Strings.nullToEmpty(valueDTO.getValue());
    }
}
