package common.config.tools.config.listener;

import common.config.tools.configcenter.ConfigCenterService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface IConfigChangeListener {
    final Logger logger = LoggerFactory.getLogger(ConfigCenterService.class);

    /**
     * 配置变更通知事件
     *
     * @param fileName
     * @param key
     * @param oldValue
     * @param newValue
     */
    default void event(String fileName, String key, String oldValue, String newValue) {
        logger.info("Config Change fileName[{}] key[{}] old[{}] new[{}]", fileName, key, oldValue, newValue);
    }
}
