package common.config.tools.config.loader.properties;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;

/**
 * Created by Frank.Huang on 2017/5/4.
 */
public class PropertiesLoader {
    private static final Logger logger = LoggerFactory.getLogger(PropertiesLoader.class);
    private static final String FILE_CODING = "utf-8";

    /**
     * 从文件load属性
     * @param file
     * @return
     * @throws IOException
     */
    public static Map<String, String> loader(File file) throws IOException {
        logger.info("Load File:[{}]", file.getAbsoluteFile());
        String content = FileUtils.readFileToString(file, Charset.forName(FILE_CODING));
        return  loader(content);
    }

    /**
     * 加载Properties文件数据
     *
     * @param content
     * @return
     * @throws IOException
     */
    public static Map<String, String> loader(String content) {
        Map<String, String> resultMap = Maps.newLinkedHashMap();
        if (Strings.isNullOrEmpty(content)) {
            return resultMap;
        }

        logger.info("Load File:[{}]", content);
        List<String> lines = Splitter.on("\n").omitEmptyStrings().trimResults().splitToList(content);
        for (String line : lines) {
            if (Strings.isNullOrEmpty(line)) {
                //skip empty line
                continue;
            }

            if (line.startsWith("#")) {
                //skip comment line
                continue;
            }

            int pos = line.indexOf("=");
            if (pos != -1) {
                String key = Strings.nullToEmpty(line.substring(0, pos)).trim();
                String value = Strings.nullToEmpty(line.substring(pos + 1).trim());
                resultMap.put(key, value);
                logger.info("Load properties: [{}={}]", key, value);
            } else {
                logger.error("Load Invalid properties[{}]", line);
            }
        }

        return resultMap;
    }

}
