package common.config.tools.configcenter.common;

public class ConfigCenterConstants {
    /**
     * SERVER_ADDR 配置中心服务域名，在使用config-server启动时不可缺少
     */
    public static final String SERVER_ADDR = "serverAddr";

    /**
     * NAMESPACE 配置中心服务中的命名空间
     */
    public static final String NAMESPACE = "namespace";

    /**
     * CONFIG_LONG_POLL_TIMEOUT  nacos-client长连接轮询超时时间 ms,默认 30000
     */
    public static final String CONFIG_LONG_POLL_TIMEOUT = "configLongPollTimeout";

    /**
     * CONFIG_RETRY_TIME  nacos-client长连接重试时长 ms,默认 2000
     */
    public static final String CONFIG_RETRY_TIME = "configRetryTime";

    /**
     * MAX_RETRY 长连接重试次数 ,默认 3
     */
    public static final String MAX_RETRY = "maxRetry";

    /**
     * ENABLE_REMOTE_SYNC_CONFIG  监听器首次添加时拉取远端配置 ,默认false
     */
    public static final String ENABLE_REMOTE_SYNC_CONFIG = "enableRemoteSyncConfig";

    /**
     * USERNAME 用户名 用于权限验证，当服务端开启权限限定时需要配置对应
     */
    public static final String USERNAME = "username";

    /**
     * PASSWORD 密码   用于权限验证
     */
    public static final String PASSWORD = "password";

    /**
     * LOCAL_CACHE_PATH 本地缓存路径
     */
    public static final String LOCAL_CACHE_PATH = "JM.SNAPSHOT.PATH";
}
