package common.config.tools.file.monitor;

import com.alibaba.nacos.api.common.Constants;
import common.config.tools.config.ConfigValueTools;
import common.config.tools.configcenter.common.ConfigOverrideTools;
import common.config.tools.config.listener.IConfigChangeListener;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.File;
import java.io.IOException;

public class FileContentListener extends FileChangeListenerAdaptor {
    private static final Logger logger = LoggerFactory.getLogger(FileContentListener.class);
    private IConfigChangeListener listener;

    public FileContentListener(boolean backupAfterProcess, IConfigChangeListener listener) {
        super(backupAfterProcess);
        this.listener = listener;
    }

    @Override
    public void onFileCreate(File file) {
        loadFile(file);
    }

    @Override
    public void onFileChange(File file) {
        loadFile(file);
    }

    @Override
    public void onFileDelete(File file) {

    }

    /**
     * @param file
     *
     * 加载文件内容
     */
    public void loadFile(File file) {
        try {
            String dataId = FilenameUtils.getName(file.getName());
            ConfigValueTools.registerListener(dataId, ConfigOverrideTools.getConfigFileWight(dataId), listener);
            ConfigValueTools.update(dataId, FileUtils.readFileToString(file, Constants.ENCODE));
        } catch (IOException e) {
            logger.warn("load file exception:{},fileName:{}", e.getMessage(), file.getName());
        }
    }


}
