package common.config.tools.model;

import java.io.Serializable;
import java.util.List;

public class ConfigCenterConfigDTO implements Serializable {
    //配置中心服务域名，在使用config-server启动时不可缺少
    private String serverHost;
    //远端配置本地缓存地址 可选 默认为当前用户目录下
    private String localCacheDir;
    //用户名 用于权限验证，当服务端开启权限限定时需要配置对应
    private String username = "";
    //密码  用于权限验证
    private String password = "";
    //nacos-client读取超时时间 s,默认 3 建议3-5
    private long readTimeout = 3;
    //nacos-client长连接轮询超时时间 ms,默认 30000
    private long configLongPollTimeout = 30000;
    //nacos-client长连接重试时长 ms,默认 2000
    private long configRetryTime = 2000;
    //长连接重试次数 ,默认 3
    private long maxRetry = 3;
    //监听器首次添加时拉取远端配置 ,默认false
    private boolean enableRemoteSyncConfig = false;
    //配置中心所需的获取配置namespaceId、group、和配置文件原名,在配置中心内dataId由 层级+文件原名组成
    private List<ConfigItemDTO> configItems;

    public String getServerHost() {
        return serverHost;
    }

    public void setServerHost(String serverHost) {
        this.serverHost = serverHost;
    }

    public String getLocalCacheDir() {
        return localCacheDir;
    }

    public void setLocalCacheDir(String localCacheDir) {
        this.localCacheDir = localCacheDir;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public List<ConfigItemDTO> getConfigItems() {
        return configItems;
    }

    public void setConfigItems(List<ConfigItemDTO> configItems) {
        this.configItems = configItems;
    }

    public long getReadTimeout() {
        return readTimeout;
    }

    public void setReadTimeout(long readTimeout) {
        this.readTimeout = readTimeout;
    }

    public long getConfigLongPollTimeout() {
        return configLongPollTimeout;
    }

    public void setConfigLongPollTimeout(long configLongPollTimeout) {
        this.configLongPollTimeout = configLongPollTimeout;
    }

    public long getConfigRetryTime() {
        return configRetryTime;
    }

    public void setConfigRetryTime(long configRetryTime) {
        this.configRetryTime = configRetryTime;
    }

    public long getMaxRetry() {
        return maxRetry;
    }

    public void setMaxRetry(long maxRetry) {
        this.maxRetry = maxRetry;
    }

    public boolean getEnableRemoteSyncConfig() {
        return enableRemoteSyncConfig;
    }

    public void setEnableRemoteSyncConfig(boolean enableRemoteSyncConfig) {
        this.enableRemoteSyncConfig = enableRemoteSyncConfig;
    }


}
