package common.config.tools.model;

import com.google.common.base.Strings;
import common.config.tools.config.ConfigValueTools;
import common.config.tools.configcenter.common.ConfigOverrideTools;
import common.config.tools.configcenter.common.RunMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.Serializable;
import java.util.*;

public class ConfigToolConfigDTO implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(ConfigToolConfigDTO.class);
    //配置继承层级 --项目/产品 可选
    private String project;
    //模块 可选
    private String module;
    //环境 可选
    private String env;
    //区域 可选
    private String region;
    //启动方式，1:本地配置启动 2:配置中心配置启动 3:混合启动（以远端配置为准）
    private int runMode = 3;
    //<K,V>形式配置文件尾缀
    private List<String> propertiesExtension = Arrays.asList("config", "properties");
    //本地启动参数
    private LocalConfigDTO localConfig = null;
    //配置中心启动参数
    private ConfigCenterConfigDTO configCenterConfig = null;

    public ConfigToolConfigDTO() {
    }

    public ConfigToolConfigDTO(int runMode, String path) {
        this.runMode = runMode;
        this.localConfig = new LocalConfigDTO(path);
    }

    public LocalConfigDTO getLocalConfig() {
        return localConfig;
    }

    public void setLocalConfig(LocalConfigDTO localConfig) {
        this.localConfig = localConfig;
    }

    public ConfigCenterConfigDTO getConfigCenterConfig() {
        return configCenterConfig;
    }

    public void setConfigCenterConfig(ConfigCenterConfigDTO configCenterConfig) {
        this.configCenterConfig = configCenterConfig;
    }

    public String getProject() {
        return project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public String getModule() {
        return module;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public String getRegion() {
        return region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getEnv() {
        return env;
    }

    public void setEnv(String env) {
        this.env = env;
    }

    public int getRunMode() {
        return runMode;
    }

    public void setRunMode(int runMode) {
        this.runMode = runMode;
    }

    public List<String> getPropertiesExtension() {
        return propertiesExtension;
    }

    public void setPropertiesExtension(List<String> propertiesExtension) {
        this.propertiesExtension = propertiesExtension;
    }


    public boolean valid() {

        if (RunMode.LOCAL == runMode) {
            if (Objects.isNull(localConfig)) {
                logger.error("Local runMode,Config json-localConfig is wrong please check");
                return false;
            }
            if (Strings.isNullOrEmpty(localConfig.getPath())) {
                logger.error("Local runMode,Config json-localConfig-path is wrong please check");
                return false;
            }

        } else if (RunMode.SERVER == runMode) {
            if (Objects.isNull(configCenterConfig)) {
                logger.error("Config center runMode,Config json-configCenter is wrong please check");
                return false;
            }
            if (Strings.isNullOrEmpty(configCenterConfig.getServerHost())) {
                logger.error("Config center runMode,Config json-configCenter-serverHost is wrong please check");
                return false;
            }

        } else if (RunMode.MIX == runMode) {
            if (Objects.isNull(localConfig) && Objects.isNull(configCenterConfig)) {
                logger.error("Mix runMode,Config json localConfig and configCenter is wrong please check");
                return false;
            }

        } else {
            logger.error("Config json-runMode is wrong please check");
            return false;
        }

        logger.info("loader info project[{}] module[{}] env[{}] region[{}] extSet[{}] runMode[{}]", project, module, env, region, propertiesExtension, runMode);
        logger.info("loader local info path[{}] recursive[{}] refreshInterval[{}]", localConfig.getPath(), localConfig.getRecursive(), localConfig.getRefreshInterval());
        logger.info("loader server info serverHost[{}] localCacheDir[{}] username[{}] password[{}] readTimeout[{}] configLongPollTimeout[{}] configRetryTime[{}] maxRetry[{}] enableRemoteSyncConfig[{}]"
                , configCenterConfig.getServerHost(), configCenterConfig.getLocalCacheDir(), configCenterConfig.getUsername(), configCenterConfig.getPassword(), configCenterConfig.getReadTimeout()
                , configCenterConfig.getConfigLongPollTimeout(), configCenterConfig.getConfigRetryTime(), configCenterConfig.getMaxRetry(), configCenterConfig.getEnableRemoteSyncConfig());
        return true;
    }


}
