package common.config.tools.model;



import java.util.Objects;

public class ConfigValueDTO {
    private String value;
    private long timestamp;
    private int weight;

    public ConfigValueDTO(String value, int weight) {
        this.value = value;
        this.timestamp = System.currentTimeMillis();
        this.weight = weight;
    }

    public ConfigValueDTO(String value) {
        this.value = value;
        this.timestamp = System.currentTimeMillis();
        this.weight = -1;
    }

    public static ConfigValueDTO valueOf(String value) {
        return new ConfigValueDTO(value);
    }

    public static ConfigValueDTO emptyValue() {
        return new ConfigValueDTO(null, Integer.MIN_VALUE);
    }

    public boolean contentEquals(ConfigValueDTO that) {
        if (Objects.isNull(value)) {
            if (Objects.isNull(that) || Objects.isNull(that.value)) {
                return true;
            } else {
                return false;
            }
        }

        return value.contentEquals(that.value);

    }

    public boolean contentEquals(String value) {
        if (Objects.isNull(this.value)) {
            if (Objects.isNull(value)) {
                return true;
            } else {
                return false;
            }
        }

        return this.value.contentEquals(value);
    }

    /**
     * 比较ConfigValueDTO的大小
     * x > y: return 1
     * x < y: return -1(权重相等,内容不等也认为是小于)
     * x = y:return 0
     *
     * @param x
     * @param y
     * @return
     */
    public static int compare(ConfigValueDTO x, ConfigValueDTO y) {
        /**
         * 先比较权重，权重
         */
        if (x.getWeight() < y.getWeight()) {
            return -1;
        }

        if (x.getWeight() > y.getWeight()) {
            return 1;
        }

        //权重相等时,如果内容不一样,就认为是小于
        if (x.contentEquals(y)) {
            return 0;
        } else {
            return -1;
        }
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public long getTimestamp() {
        return timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public int getWeight() {
        return weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }


}
