package common.config.tools.model;

import com.google.common.base.Strings;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;

public class LocalConfigDTO implements Serializable {
    //读取本地配置路径
    private String path = "config";
    //监听本地配置变更周期,刷新间隔 s 默认60
    private long refreshInterval = 60;
    //递归读取本地配置开关
    private boolean recursive = true;

    public LocalConfigDTO() {
    }

    public LocalConfigDTO(String path) {
        if (!Strings.isNullOrEmpty(path)){
            this.path = path;
        }
    }

    public String getPath() {
        return path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public long getRefreshInterval() {
        return refreshInterval;
    }

    public void setRefreshInterval(long refreshInterval) {
        this.refreshInterval = refreshInterval;
    }

    public boolean getRecursive() {
        return recursive;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
    }
}
