/*
 * Decompiled with CFR 0.152.
 */
package common.config.tools.config;

import common.config.tools.config.AbstractConfigTools;
import common.config.tools.config.ConfigValueTools;
import common.config.tools.config.listener.IConfigChangeListener;
import common.config.tools.configcenter.ConfigCenterService;
import common.config.tools.configcenter.common.ConfigOverrideTools;
import common.config.tools.file.monitor.FileContentListener;
import common.config.tools.file.monitor.PathFileMonitor;
import common.config.tools.model.ConfigToolConfigDTO;
import common.config.tools.model.LocalConfigDTO;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigRouteTools {
    private static final Logger logger = LoggerFactory.getLogger(ConfigRouteTools.class);

    public void loadConfig(ConfigToolConfigDTO configObj, IConfigChangeListener listener) {
        long start = System.currentTimeMillis();
        this.initParameter(configObj);
        switch (configObj.getRunMode()) {
            case 1: {
                this.localStart(configObj, listener);
                break;
            }
            case 2: {
                this.configCenterStart(configObj, listener);
                break;
            }
            case 3: {
                this.localStart(configObj, listener);
                this.configCenterStart(configObj, listener);
                break;
            }
        }
        logger.info("loading finished,runMode:[{}] time consume:[{}]s", (Object)configObj.getRunMode(), (Object)((double)(System.currentTimeMillis() - start) / 1000.0));
    }

    private void initParameter(ConfigToolConfigDTO configObj) {
        ConfigOverrideTools.initLevels(configObj.getProject(), configObj.getModule(), configObj.getEnv(), configObj.getRegion());
        ConfigValueTools.extSet = new HashSet<String>(configObj.getPropertiesExtension());
    }

    private void localStart(ConfigToolConfigDTO configObj, IConfigChangeListener listener) {
        LocalConfigDTO localInitInfo = configObj.getLocalConfig();
        new PathFileMonitor(localInitInfo.getRefreshInterval()).monitorPath(AbstractConfigTools.replaceDirectoryPath(localInitInfo.getPath()), null, null, new FileContentListener(false, listener), localInitInfo.getRecursive()).start();
    }

    private void configCenterStart(ConfigToolConfigDTO configObj, IConfigChangeListener listener) {
        new ConfigCenterService(configObj.getConfigCenterConfig()).load(listener);
    }
}

