/*
 * Decompiled with CFR 0.152.
 */
package common.config.tools.config.loader.properties;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesLoader {
    private static final Logger logger = LoggerFactory.getLogger(PropertiesLoader.class);
    private static final String FILE_CODING = "utf-8";

    public static Map<String, String> loader(File file) throws IOException {
        logger.info("Load File:[{}]", (Object)file.getAbsoluteFile());
        String content = FileUtils.readFileToString((File)file, (Charset)Charset.forName(FILE_CODING));
        return PropertiesLoader.loader(content);
    }

    public static Map<String, String> loader(String content) {
        LinkedHashMap resultMap = Maps.newLinkedHashMap();
        if (Strings.isNullOrEmpty((String)content)) {
            return resultMap;
        }
        logger.info("Load File:[{}]", (Object)content);
        List lines = Splitter.on((String)"\n").omitEmptyStrings().trimResults().splitToList((CharSequence)content);
        for (String line : lines) {
            if (Strings.isNullOrEmpty((String)line) || line.startsWith("#")) continue;
            int pos = line.indexOf("=");
            if (pos != -1) {
                String key = Strings.nullToEmpty((String)line.substring(0, pos)).trim();
                String value = Strings.nullToEmpty((String)line.substring(pos + 1).trim());
                resultMap.put(key, value);
                logger.info("Load properties: [{}={}]", (Object)key, (Object)value);
                continue;
            }
            logger.error("Load Invalid properties[{}]", (Object)line);
        }
        return resultMap;
    }
}

