/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.utils;

import com.alibaba.nacos.common.utils.BiFunction;
import com.alibaba.nacos.common.utils.CollectionUtils;
import com.alibaba.nacos.common.utils.Objects;
import com.alibaba.nacos.common.utils.StringUtils;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Map;

public class MapUtils {
    public static boolean isEmpty(Map map) {
        return map == null || map.isEmpty();
    }

    public static boolean isEmpty(Dictionary coll) {
        return coll == null || coll.isEmpty();
    }

    public static boolean isNotEmpty(Map map) {
        return !MapUtils.isEmpty(map);
    }

    public static boolean isNotEmpty(Dictionary coll) {
        return !MapUtils.isEmpty(coll);
    }

    public static void putIfValNoNull(Map target, Object key, Object value) {
        Objects.requireNonNull(key, "key");
        if (value != null) {
            target.put(key, value);
        }
    }

    public static void putIfValNoEmpty(Map target, Object key, Object value) {
        Objects.requireNonNull(key, "key");
        if (value instanceof String) {
            if (StringUtils.isNotEmpty((String)value)) {
                target.put(key, value);
            }
            return;
        }
        if (value instanceof Collection) {
            if (CollectionUtils.isNotEmpty((Collection)value)) {
                target.put(key, value);
            }
            return;
        }
        if (value instanceof Map) {
            if (MapUtils.isNotEmpty((Map)value)) {
                target.put(key, value);
            }
            return;
        }
        if (value instanceof Dictionary) {
            if (MapUtils.isNotEmpty((Dictionary)value)) {
                target.put(key, value);
            }
            return;
        }
    }

    public static Object computeIfAbsent(Map target, Object key, BiFunction mappingFunction, Object param1, Object param2) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(key, "mappingFunction");
        Objects.requireNonNull(key, "param1");
        Objects.requireNonNull(key, "param2");
        Object val = target.get(key);
        if (val == null) {
            Object ret = mappingFunction.apply(param1, param2);
            target.put(key, ret);
            return ret;
        }
        return val;
    }
}

