/*
 * Decompiled with CFR 0.152.
 */
package common.config.tools.config;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import common.config.tools.config.AbstractConfigData;
import common.config.tools.config.loader.json.JsonSerialize;
import common.config.tools.model.ConfigValueDTO;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConfigTools
extends AbstractConfigData {
    private static final Logger logger = LoggerFactory.getLogger(AbstractConfigTools.class);

    public static String getString(String key, boolean nonEmpty) {
        String value = "";
        ConfigValueDTO valueDTO = (ConfigValueDTO)configMap.get(key);
        value = valueDTO == null && enableEnv ? System.getenv(key) : valueDTO.getValue();
        if (nonEmpty && Strings.isNullOrEmpty((String)value)) {
            throw new NullPointerException(String.format("[%s] is empty", key));
        }
        return Strings.nullToEmpty((String)value);
    }

    public static String getString(String key) {
        return AbstractConfigTools.getString(key, false);
    }

    public static String getNonEmptyString(String key) {
        return AbstractConfigTools.getString(key, true);
    }

    public static String getString(String key, String defaultValue) {
        String value = AbstractConfigTools.getString(key);
        if (Strings.isNullOrEmpty((String)value)) {
            return defaultValue;
        }
        return value;
    }

    public static List<String> getAsList(String key, String split) {
        String value = AbstractConfigTools.getString(key);
        if (Strings.isNullOrEmpty((String)value)) {
            return Lists.newArrayList();
        }
        try {
            return Splitter.on((String)split).omitEmptyStrings().splitToList((CharSequence)value);
        }
        catch (Exception e) {
            return Lists.newArrayList();
        }
    }

    public static List<String> getAsList(String key) {
        return AbstractConfigTools.getAsList(key, ",");
    }

    public static Long getLong(String key, Long defaultValue) {
        String strValue = AbstractConfigTools.getString(key);
        if (Strings.isNullOrEmpty((String)strValue)) {
            return defaultValue;
        }
        try {
            return Long.parseLong(strValue);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static Long getLong(String key) {
        return AbstractConfigTools.getLong(key, null);
    }

    public static Integer getInt(String key, Integer defaultValue) {
        String strValue = AbstractConfigTools.getString(key);
        if (Strings.isNullOrEmpty((String)strValue)) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(strValue);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static Integer getInt(String key) {
        return AbstractConfigTools.getInt(key, null);
    }

    public static boolean getBoolean(String key, boolean defaultValue) {
        Boolean bool = AbstractConfigTools.getBoolean(key);
        if (Objects.nonNull(bool)) {
            return bool;
        }
        return defaultValue;
    }

    public static Boolean getBoolean(String key) {
        String value = AbstractConfigTools.getString(key);
        if (Strings.isNullOrEmpty((String)value)) {
            return null;
        }
        if ("true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value) || "y".equalsIgnoreCase(value) || "1".equalsIgnoreCase(value)) {
            return true;
        }
        return false;
    }

    public static <T> T getJsonObj(String filename, Class c) throws JsonProcessingException {
        String value = AbstractConfigTools.getString(filename);
        if (Strings.isNullOrEmpty((String)value)) {
            return null;
        }
        ObjectMapper mapper = new ObjectMapper();
        return (T)mapper.readValue(value, c);
    }

    public static <T> T getJsonObj(String key, TypeReference typeReference) {
        String valueStr = AbstractConfigTools.getString(key);
        if (Strings.isNullOrEmpty((String)valueStr)) {
            return null;
        }
        return JsonSerialize.fromJson(valueStr, typeReference);
    }

    @Deprecated
    public static boolean getAsBoolean(String key, boolean defaultValue) {
        return AbstractConfigTools.getBoolean(key, defaultValue);
    }

    public static Map<String, String> getAsMap(String key, String itemSeparator, String keyValueSeparator) {
        String value = null;
        try {
            value = AbstractConfigTools.getString(key);
            if (!Strings.isNullOrEmpty((String)value)) {
                itemSeparator = Strings.isNullOrEmpty((String)itemSeparator) ? "&" : itemSeparator;
                keyValueSeparator = Strings.isNullOrEmpty((String)keyValueSeparator) ? ":" : keyValueSeparator;
                return Splitter.on((String)itemSeparator).withKeyValueSeparator(keyValueSeparator).split((CharSequence)value);
            }
        }
        catch (Exception e) {
            logger.error("Splitter [{}-{}] [{}] to map exception", new Object[]{itemSeparator, keyValueSeparator, value, e.getMessage()});
        }
        return null;
    }

    public static Map<String, String> getAsMap(String key) {
        return AbstractConfigTools.getAsMap(key, "&", "=");
    }

    public static Map<String, ConfigValueDTO> getAllConfig() {
        return configMap;
    }

    public static String replaceDirectoryPath(String path) {
        if (Strings.isNullOrEmpty((String)path)) {
            return path;
        }
        return path.replace("${user.home}", FileUtils.getUserDirectoryPath()).replace("${java.io.tmpdir}", FileUtils.getTempDirectoryPath());
    }

    @Deprecated
    public static String getConfigAsString(String key, String defaultValue) {
        return AbstractConfigTools.getString(key, defaultValue);
    }

    @Deprecated
    public static String getConfigAsString(String key) {
        return AbstractConfigTools.getString(key, "");
    }

    @Deprecated
    public static Long getConfigAsLong(String key, Long defaultValue) {
        return AbstractConfigTools.getLong(key, defaultValue);
    }

    @Deprecated
    public static Long getConfigAsLong(String key) {
        return AbstractConfigTools.getLong(key, null);
    }

    @Deprecated
    public static Integer getConfigAsInt(String key, Integer defaultValue) {
        return AbstractConfigTools.getInt(key, defaultValue);
    }

    @Deprecated
    public static Integer getConfigAsInt(String key) {
        return AbstractConfigTools.getInt(key, null);
    }
}

