package common.config.tools.config;

import com.google.common.collect.Maps;
import common.config.tools.model.ConfigValueDTO;

import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;


/**
 * Created by Frank.Huang on 2017/2/27.
 */
public abstract class AbstractConfigData {
    protected static Map<String, ConfigValueDTO> configMap = Maps.newConcurrentMap();
    protected static long interval = 60 * 1000L;
    protected static boolean enableEnv = true;
    public static final String DOT = ".";
    public static final String SPLIT_STR = ",";
    protected static ScheduledExecutorService scheduledThreadPool = new ScheduledThreadPoolExecutor(10);


    public static void enableEnv(boolean enableEnv) {
        AbstractConfigData.enableEnv = enableEnv;
    }

    public static void setInterval(long interval) {
        AbstractConfigData.interval = interval;
    }

}
