package common.config.tools.config;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import common.config.tools.aes.AESTools;

import java.util.List;

/**
 *
 * @author Frank.Huang
 * @date 2017/5/29
 */
public class ConfigAESTools extends ConfigTools3 {
    public static String getAESString(String key, String aeskey, String defaultValue) {
        String v = getAESString(key, aeskey);
        if (Strings.isNullOrEmpty(v)) {
            return defaultValue;
        }

        return v;
    }

    public static String getAESString(String key, String aeskey) {
        String original = getString(key);
        if (Strings.isNullOrEmpty(original)) {
            return "";
        }

        try {
            return AESTools.decrypt(original, aeskey);
        } catch (Exception e) {
            return "";
        }
    }

    public static List<String> getAESAsList(String key, String aeskey, String split) {
        String value = getString(key, aeskey);
        if (Strings.isNullOrEmpty(value)) {
            return Lists.newArrayList();
        }

        return Splitter.on(split).omitEmptyStrings().splitToList(value);
    }

    public static List<String> getAESAsList(String key, String aeskey) {
        return getAsList(key, ",");
    }
}
