package common.config.tools.config;

import com.google.common.base.Strings;
import common.config.tools.data.DataChangeListener;
import common.config.tools.data.I18nTools;
import common.config.tools.data.IDataChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Objects;
import java.util.concurrent.TimeUnit;

/**
 * Created by Frank.Huang on 2017/2/27.
 */
@Deprecated
public class I18nConfigTools extends AbstractConfigData {
    private static final Logger logger = LoggerFactory.getLogger(I18nConfigTools.class);

    /**
     * Load external data
     *
     * @param iDataChangeLister:Load external data change listener
     */
    public static void loadData(IDataChangeListener iDataChangeLister) {
        DataChangeListener listener = new DataChangeListener(interval, configMap, Objects.requireNonNull(iDataChangeLister, "DataChangeLister is NULL"));
        scheduledThreadPool.scheduleAtFixedRate(listener, 0, listener.getQueryInterval(), TimeUnit.MILLISECONDS);
    }

    /**
     * Get i18n config value
     *
     * @param lang
     * @param key
     * @return
     */
    public static String getI18nString(String lang, String key) {
        String enKey = I18nTools.buildI18nKey(lang, key);
        String value = configMap.get(enKey).getValue();
        if (Objects.isNull(value)) {
            if (!I18nTools.isLangEN(lang)) {
                enKey = I18nTools.buildI18nKey(I18nTools.LANG_EN, key);
                value = configMap.get(enKey).getValue();
            }
        }

        return Strings.nullToEmpty(value);
    }
}
