package common.config.tools.config.loader.json;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;

import com.google.common.base.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.File;
import java.io.IOException;

/**
 * @author Frank.Huang
 * @date 2017/7/2
 */
public class JsonSerialize {
    private static final Logger logger = LoggerFactory.getLogger(JsonSerialize.class);

    public static Object loadJson(File file, TypeReference typeReference) {
        if (typeReference == null) {
            logger.info("Can NOT find Type for json,skip[{}]", file.getAbsolutePath());
            return null;
        }

        return fromJson(file, typeReference);
    }

    public static Object fromJson(File json, TypeReference typeReference) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

            String jsonStr = JsonLoader.readToString(json);
            return objectMapper.readValue(jsonStr, typeReference);
        } catch (IOException e) {
            logger.error("Load Json[{}] exception:{}", json.getAbsolutePath(), e);
            return null;
        }
    }

    /**
     * 从字符串获取json对象，如果获取失败，返回null
     *
     * @param json
     * @param typeReference
     * @param <T>
     * @return
     */
    public static <T> T fromJson(String json, TypeReference typeReference) {
        if (Strings.isNullOrEmpty(json)) {
            return null;
        }

        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            return (T) objectMapper.readValue(json, typeReference);
        } catch (IOException e) {
            logger.error("Load Json[{}] exception:{}", json, e);
            return null;
        }
    }

    /**
     * 从字符串获取json对象，如果解析失败,返回null
     *
     * @param json
     * @param clazz
     * @param <T>
     * @return
     */
    public static <T> T fromJson(String json, Class clazz) {
        if (Strings.isNullOrEmpty(json)) {
            return null;
        }

        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            return (T) objectMapper.readValue(json, clazz);
        } catch (IOException e) {
            logger.error("Load Json[{}] exception:{}", json, e);
            return null;
        }
    }
}
