package common.config.tools.configcenter;

import com.alibaba.nacos.api.config.listener.Listener;
import common.config.tools.config.ConfigValueTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.concurrent.Executor;

public class ConfigCenterListener implements Listener {
    private static final Logger logger = LoggerFactory.getLogger(ConfigCenterListener.class);

    private String dataId;

    public ConfigCenterListener(String dataId) {
        this.dataId = dataId;
    }

    @Override
    public void receiveConfigInfo(String configInfo) {
        logger.info("Updated the configuration file:[{}],content:[{}]", dataId, configInfo);
        ConfigValueTools.update(dataId, configInfo);
    }

    @Override
    public Executor getExecutor() {
        return null;
    }
}
