package common.config.tools.data;

import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.google.common.hash.Hashing;

public class I18nTools {
    public static final String LANG_EN = "en";

    /**
     * Build i18n config key
     *
     * @param lang
     * @param key
     * @return
     */
    public static String buildI18nKey(String lang, String key) {
        String langStr = lang.toLowerCase();
        if (Strings.isNullOrEmpty(langStr)) {
            langStr = LANG_EN;
        }

        String keyStr = Strings.nullToEmpty(key);
        if (key.length() > 32) {
            keyStr = Hashing.hmacMd5("live.tve".getBytes()).hashString(keyStr, Charsets.UTF_8).toString();
        }

        return String.format("%s.%s", langStr, keyStr);
    }

    /**
     * Judge language is en or not.
     *
     * @param langCode
     * @return
     */
    public static boolean isLangEN(String langCode) {
        return Strings.nullToEmpty(langCode).equalsIgnoreCase(LANG_EN);
    }

}
