package common.config.tools.data;

import com.google.common.base.Strings;
import common.config.tools.data.model.PropertyDataObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;
import java.util.Map;

public interface IDataChangeListener<T extends IPropertyData> {
    static final Logger logger = LoggerFactory.getLogger(IDataChangeListener.class);

    /**
     * Query config data
     *
     * @return
     */
    List<T> queryData(long lmt);

    /**
     * Process config data object
     *
     * @param object
     */
    default void processData(T object, Map<String, String> properties) {
        String key = object.buildKey();
        String v = Strings.nullToEmpty(properties.get(key));
        if (object.getStatus() == 0) {
            if (!Strings.isNullOrEmpty(v)) {
                properties.remove(key);
                logger.info("[DataLoader][delete][{}]=[{}]", key, object.getValue());
            }
        } else {
            properties.put(key, object.getValue());
            logger.info("[DataLoader][Update][{}]=[{}->{}]", key, v, object.getValue());
        }
    }
}
