package common.config.tools.file.monitor;

import com.fasterxml.jackson.core.type.TypeReference;
import common.config.tools.config.loader.json.JsonSerialize;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.File;
import java.util.Map;

public class JsonListener<T extends TypeReference, V> extends FileChangeListenerAdaptor {
    private static final Logger logger = LoggerFactory.getLogger(JsonListener.class);

    private T type = null;
    private Map<String, V> value = null;
    private String fn = null;

    public JsonListener(boolean backupAfterProcess, String fn, T type, Map<String, V> valueMap) {
        super(backupAfterProcess);
        this.type = type;
        this.value = valueMap;
        this.fn = fn;
    }

    @Override
    public void onFileCreate(File file) {
        loadJson(file);
    }

    @Override
    public void onFileChange(File file) {
        loadJson(file);
    }

    @Override
    public void onFileDelete(File file) {

    }

    public void loadJson(File file) {
        String fn = FilenameUtils.getName(file.getName());

        if (this.fn.contentEquals(fn)) {
            value.put(fn, (V) JsonSerialize.loadJson(file, type));
            logger.info("Load file[{}]", fn);
        } else {
            logger.info("[SKIP]filename[{}]", fn);
        }
    }
}
