/*
 * Decompiled with CFR 0.152.
 */
package common.config.tools.file.monitor;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import common.config.tools.file.monitor.FileNameFilter;
import common.config.tools.file.monitor.IFileChangeListener;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NotFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationMonitor;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathFileMonitor {
    private static final Logger logger = LoggerFactory.getLogger(PathFileMonitor.class);
    private FileAlterationMonitor monitor;
    private long interval = 0L;

    public PathFileMonitor(long interval) {
        this.interval = interval;
        if (this.interval > 0L) {
            if (this.interval < 1000L) {
                this.interval = 1000L;
            }
            this.monitor = new FileAlterationMonitor(interval);
        } else {
            this.monitor = new FileAlterationMonitor(600000L);
        }
    }

    public PathFileMonitor monitorPath(String filePath, String fileNamePattern, Set<String> extSet, IFileChangeListener listener, boolean recursive) {
        File root = FileUtils.getFile((String[])new String[]{filePath});
        if (!root.isDirectory() || !root.exists()) {
            logger.warn("File [{}] is not Directory or not Exist.", (Object)root);
            return this;
        }
        IOFileFilter fileFilter = FileFilterUtils.fileFileFilter();
        if (extSet != null && extSet.size() > 0) {
            fileFilter = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{fileFilter, new SuffixFileFilter((List)Lists.newArrayList(extSet))});
        }
        if (!Strings.isNullOrEmpty((String)fileNamePattern)) {
            fileFilter = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{fileFilter, new FileNameFilter(fileNamePattern)});
        }
        this.load(listener, root, fileFilter, recursive);
        if (this.interval > 0L) {
            ArrayList paths = Lists.newArrayList();
            if (recursive) {
                Collection subDirs = FileUtils.listFilesAndDirs((File)root, (IOFileFilter)new NotFileFilter(TrueFileFilter.INSTANCE), (IOFileFilter)DirectoryFileFilter.DIRECTORY);
                paths.addAll(subDirs);
            } else {
                paths.add(root);
            }
            for (File dir : paths) {
                FileAlterationObserver observer = this.getFileAlterationObserver(dir, fileFilter, listener);
                this.monitor.addObserver(observer);
                logger.info("Monitor Directory[{}] Filter[Name:{} Extension:{}].", new Object[]{dir.getAbsolutePath(), fileNamePattern, extSet});
            }
        }
        return this;
    }

    private void load(IFileChangeListener listener, File rootPath, IOFileFilter fileFilter, boolean recursive) {
        Collection files = Collections.EMPTY_SET;
        files = recursive ? FileUtils.listFiles((File)rootPath, (IOFileFilter)fileFilter, (IOFileFilter)FileFilterUtils.directoryFileFilter()) : FileUtils.listFiles((File)rootPath, (IOFileFilter)fileFilter, null);
        if (files != null) {
            files.forEach(e -> listener.onFileChange((File)e));
        }
    }

    private FileAlterationObserver getFileAlterationObserver(File rootPath, IOFileFilter fileFilter, IFileChangeListener listener) {
        FileAlterationObserver observer = new FileAlterationObserver(rootPath, (FileFilter)fileFilter);
        observer.addListener((FileAlterationListener)listener);
        return observer;
    }

    public void start() {
        try {
            this.monitor.start();
        }
        catch (Exception e) {
            logger.info("Start exception:{}", (Throwable)e);
        }
    }

    public void stop() {
        try {
            this.monitor.stop();
        }
        catch (Exception e) {
            logger.info("Stop exception:{}", (Throwable)e);
        }
    }
}

