package com.valor.common.db.model.properties;

import com.valor.common.db.model.AbstractAuditDdo;
import common.config.tools.data.IPropertyData;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;


@MappedSuperclass
@Data
@NoArgsConstructor
public class AbstractPropertiesDdo extends AbstractAuditDdo implements IPropertyData {
    @Id
    @Column(name = "tag", length = 128)
    private String tag;

    @Column(name = "value", length = 2048)
    private String value;

    @Override
    public String buildKey() {
        return tag;
    }
}
