package com.valor.common.db.model;

import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

import javax.persistence.Column;
import javax.persistence.MappedSuperclass;
import java.io.Serializable;
import java.util.Date;


/**
 * DB　Table Audit field
 */

@Data
@NoArgsConstructor
@MappedSuperclass
public class AbstractAuditDdo implements Serializable {
    // data status
    @Column(name = "status", columnDefinition = "INT default 1")
    private int status;

    @Column(name = "create_time", updatable = false)
    private Date createTime = new Date();

    @Column(name = "update_time", columnDefinition = "TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP")
    private Date updateTime = new Date();

    @Column(name = "update_user", length = 64)
    private String updateUser;

    @Column(name = "remark", length = 1024)
    private String remark;

    public long getUpdateTimestamp() {
        if (updateTime != null) {
            return updateTime.getTime();
        } else {
            return 0;
        }
    }
}
