package com.valor.common.db.model.properties;

import com.google.common.base.Joiner;
import com.valor.common.db.model.AbstractAuditDdo;
import common.config.tools.data.IPropertyData;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

@Data
@NoArgsConstructor
@Entity
@Table(name = "common_properties_i18n")
public class PropertiesI18nDdo extends AbstractAuditDdo implements IPropertyData {
    @Id
    @Column(name = "lang", length = 16)
    private String lang;

    @Id
    @Column(name = "tag", length = 1024)
    private String tag;

    @Column(name = "value", length = 2048)
    private String value;

    @Override
    public String buildKey() {
        return Joiner.on(".").join(lang, tag);
    }
}
