/*
 * Decompiled with CFR 0.152.
 */
package com.valor.common.db.config;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.zaxxer.hikari.HikariDataSource;
import common.config.tools.config.ConfigAESTools;
import common.config.tools.config.ConfigTools3;
import java.util.Objects;
import java.util.Properties;
import java.util.function.BiConsumer;
import javax.sql.DataSource;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.orm.hibernate5.HibernateTransactionManager;
import org.springframework.orm.hibernate5.LocalSessionFactoryBean;
import org.springframework.transaction.PlatformTransactionManager;

public abstract class AbstractDBConfig {
    private final Logger logger = LoggerFactory.getLogger(AbstractDBConfig.class);
    protected String cfgNamePrefix = "";
    protected String driverClassName;
    protected String dialect;
    protected String validationQuery;
    protected String hbm2ddlAuto;
    protected boolean showSql;
    protected boolean generateStatistics;
    protected int maxActive;
    protected int minIdle;
    protected long idleTimeout;
    protected int txTimeout;

    public AbstractDBConfig() {
        this.cfgNamePrefix = "";
    }

    public AbstractDBConfig(String dbConfigName) {
        this.cfgNamePrefix = dbConfigName;
    }

    public DataSource getDataSource() {
        String decryptKey = this.getStringConfig("db.encrypt.key", "");
        String host = this.getDBConfig("db.host", decryptKey);
        String dbInst = this.getDBConfig("db.instance", decryptKey);
        String username = this.getDBConfig("db.username", decryptKey);
        String password = this.getDBConfig("db.password", decryptKey);
        if (Strings.isNullOrEmpty((String)host) || Strings.isNullOrEmpty((String)dbInst) || Strings.isNullOrEmpty((String)username) || Strings.isNullOrEmpty((String)password)) {
            throw new IllegalArgumentException(String.format("Database[%s] does not have the proper configuration", this.cfgNamePrefix));
        }
        String jdbcTpl = this.getStringConfig("db.jdbc.tpl", "jdbc:mysql://%s/%s?useUnicode=true&characterEncoding=utf8&autoReconnect=true&useSSL=false&serverTimezone=Asia/Shanghai");
        String dbUrl = String.format(jdbcTpl, host, dbInst);
        this.driverClassName = this.getStringConfig("db.driverClassName", "com.mysql.jdbc.Driver");
        this.validationQuery = this.getStringConfig("db.validationQuery", "SELECT 1");
        this.maxActive = this.getIntConfig("db.pool.maxActive", 50);
        this.minIdle = this.getIntConfig("db.pool.minIdle", 10);
        this.idleTimeout = this.getIntConfig("db.pool.IdleTimeout", 60000);
        this.txTimeout = this.getIntConfig("db.txTimeout", 1800);
        HikariDataSource datasource = new HikariDataSource();
        datasource.setPoolName(String.format("hikari-pool-%s", Strings.nullToEmpty((String)this.cfgNamePrefix)));
        datasource.setJdbcUrl(dbUrl);
        datasource.setUsername(username);
        datasource.setPassword(password);
        datasource.setIdleTimeout(this.idleTimeout);
        datasource.setDriverClassName(this.driverClassName);
        datasource.setConnectionInitSql(this.validationQuery);
        datasource.setMinimumIdle(this.minIdle);
        datasource.setMaximumPoolSize(this.maxActive);
        this.printHikariProperties(datasource);
        return datasource;
    }

    public Properties getDBProperties() {
        Properties props = new Properties();
        this.dialect = this.getStringConfig("db.dialect", "org.hibernate.dialect.MySQL55Dialect");
        this.hbm2ddlAuto = this.getStringConfig("db.hbm2ddlAuto", "update");
        this.showSql = this.getBoolConfig("db.stat.showSql", false);
        this.generateStatistics = this.getBoolConfig("db.stat.generateStatistics", false);
        props.put("hibernate.dialect", this.dialect);
        props.put("hibernate.show_sql", (Object)this.showSql);
        props.put("hibernate.format_sql", (Object)false);
        props.put("hibernate.generate_statistics", (Object)this.generateStatistics);
        props.put("hibernate.hbm2ddl.auto", this.hbm2ddlAuto);
        props.put("hibernate.connection.isolation", (Object)2);
        props.put("hibernate.use_sql_comments", (Object)true);
        props.put("hibernate.cache.use_second_level_cache", (Object)false);
        props.put("hibernate.cache.use_query_cache", (Object)false);
        props.put("hibernate.connection.CharSet", "utf8");
        props.put("hibernate.connection.characterEncoding", "utf8");
        props.put("hibernate.connection.useUnicode", (Object)true);
        props.put("hibernate.autoReconnect", (Object)true);
        this.printHibernateProperties(props);
        return props;
    }

    public FactoryBean<SessionFactory> getSessionFactory(DataSource dataSource) {
        LocalSessionFactoryBean sessionFactoryBean = new LocalSessionFactoryBean();
        String scanPackages = this.getStringConfig("db.scanPackages", "");
        String selfScanPackages = "com.valor.common.db";
        if (this.getBoolConfig("db.common.properties.enable", true)) {
            scanPackages = Joiner.on((String)",").skipNulls().join((Object)Strings.emptyToNull((String)scanPackages), (Object)selfScanPackages, new Object[0]);
        }
        if (!Strings.isNullOrEmpty((String)scanPackages)) {
            sessionFactoryBean.setPackagesToScan(scanPackages.split(","));
        }
        sessionFactoryBean.setHibernateProperties(this.getDBProperties());
        sessionFactoryBean.setDataSource(dataSource);
        return sessionFactoryBean;
    }

    public PlatformTransactionManager getTransactionManager(SessionFactory sessionFactory) {
        HibernateTransactionManager transactionManager = new HibernateTransactionManager(sessionFactory);
        transactionManager.setDefaultTimeout(this.txTimeout);
        return transactionManager;
    }

    private void printHikariProperties(HikariDataSource datasource) {
        if (Objects.isNull(datasource)) {
            return;
        }
        this.logger.info("[Hikari]PoolName=[{}]", (Object)datasource.getPoolName());
        this.logger.info("[Hikari]JdbcUrl=[{}]", (Object)datasource.getJdbcUrl());
        this.logger.info("[Hikari]Username=[{}]", (Object)datasource.getUsername());
        this.logger.info("[Hikari]IdleTimeout=[{}]", (Object)datasource.getIdleTimeout());
        this.logger.info("[Hikari]DriverClassName=[{}]", (Object)datasource.getDriverClassName());
        this.logger.info("[Hikari]ConnectionInitSql=[{}]", (Object)datasource.getConnectionInitSql());
        this.logger.info("[Hikari]MinimumIdle=[{}]", (Object)datasource.getMinimumIdle());
        this.logger.info("[Hikari]MaximumPoolSize=[{}]", (Object)datasource.getMaximumPoolSize());
        this.logger.info("[Hikari]Catalog=[{}]", (Object)datasource.getCatalog());
        this.logger.info("[Hikari]ConnectionTimeout=[{}]", (Object)datasource.getConnectionTimeout());
        this.logger.info("[Hikari]ValidationTimeout=[{}]", (Object)datasource.getValidationTimeout());
    }

    private void printHibernateProperties(Properties props) {
        if (Objects.isNull(props)) {
            return;
        }
        props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> this.logger.info("[hibernate]{}=[{}]", k, v)));
    }

    public String getDBConfig(String configKey, String cryptKey) {
        String configItem = this.buildConfigKey(this.cfgNamePrefix, configKey);
        if (Strings.isNullOrEmpty((String)cryptKey)) {
            return ConfigTools3.getString((String)configItem);
        }
        return ConfigAESTools.getAESString((String)configItem, (String)cryptKey);
    }

    private String buildConfigKey(String configName, String configItem) {
        if (Strings.isNullOrEmpty((String)configName)) {
            return configItem;
        }
        return String.format("%s.%s", configName, configItem);
    }

    protected String getStringConfig(String configItem, String defaultValue) {
        String key = this.buildConfigKey(this.cfgNamePrefix, configItem);
        String value = ConfigTools3.getString((String)key);
        if (Strings.isNullOrEmpty((String)value) && !Strings.isNullOrEmpty((String)this.cfgNamePrefix)) {
            value = ConfigTools3.getString((String)configItem);
        }
        if (Strings.isNullOrEmpty((String)value)) {
            return defaultValue;
        }
        return value;
    }

    protected int getIntConfig(String configItem, int defaultValue) {
        String key = this.buildConfigKey(this.cfgNamePrefix, configItem);
        Integer value = ConfigTools3.getInt((String)key);
        if (Objects.isNull(value) && !Strings.isNullOrEmpty((String)this.cfgNamePrefix)) {
            value = ConfigTools3.getInt((String)configItem);
        }
        if (Objects.nonNull(value)) {
            return value;
        }
        return defaultValue;
    }

    protected boolean getBoolConfig(String configItem, Boolean defaultValue) {
        String key = this.buildConfigKey(this.cfgNamePrefix, configItem);
        Boolean value = ConfigTools3.getBoolean((String)key);
        if (Objects.isNull(value) && !Strings.isNullOrEmpty((String)this.cfgNamePrefix)) {
            value = ConfigTools3.getBoolean((String)configItem);
        }
        if (Objects.nonNull(value)) {
            return value;
        }
        return defaultValue;
    }
}

