package com.valor.common.db.model.properties;

import com.google.common.base.Joiner;
import com.valor.common.db.model.AbstractAuditDdo;
import common.config.tools.data.IPropertyData;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

import javax.persistence.*;

@Data
@NoArgsConstructor
@Entity
@Table(name = "common_properties_i18n")
public class PropertiesI18nDdo extends AbstractAuditDdo implements IPropertyData {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "id")
    protected long id;

    @Column(name = "lang", length = 16)
    private String lang;

    @Column(name = "tag", length = 2048)
    private String tag;

    @Column(name = "value", length = 2048)
    private String value;

    @Override
    public String buildKey() {
        return Joiner.on(".").join(lang, tag);
    }
}
