package com.valor.common.db.model.properties;

import com.google.common.base.Joiner;
import common.config.tools.data.IPropertyData;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.experimental.SuperBuilder;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.Properties;

@Data
@NoArgsConstructor
@Entity
@Table(name = "common_properties_error")
public class PropertiesErrorDdo extends AbstractPropertiesDdo implements IPropertyData {
    @Id
    @Column(name = "lang", length = 16)
    private String lang;

    @Id
    @Column(name = "release_id", length = 64)
    private String releaseId;


    @Override
    public String buildKey() {
        return Joiner.on(".").skipNulls().join(getReleaseId(), getLang(), getTag());
    }
}
