package common.ipdb.model;

import com.google.common.base.MoreObjects;

/**
 * IP information
 */
public class IPInfo extends IPASNInfo {
    private String ip;
    private String city;
    private String region;
    private String country;
    
    private double latitude;
    private double longitude;
    private String geoHash;
    private String location; //location
    private String postCode; //location
    private String org; //

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getRegion() {
        return region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getCountry() {
        return country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public double getLatitude() {
        return latitude;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public double getLongitude() {
        return longitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public String getGeoHash() {
        return geoHash;
    }

    public void setGeoHash(String geoHash) {
        this.geoHash = geoHash;
    }

    public String getLocation() {
        return location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getPostCode() {
        return postCode;
    }

    public void setPostCode(String postCode) {
        this.postCode = postCode;
    }

    public String getOrg() {
        return org;
    }

    public void setOrg(String org) {
        this.org = org;
    }


    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
            .add("ip", ip)
            .add("city", city)
            .add("region", region)
            .add("country", country)
            .add("latitude", latitude)
            .add("longitude", longitude)
            .add("geoHash", geoHash)
            .add("location", location)
            .add("postCode", postCode)
            .add("org", org)
            .add("ASN", super.getASN())
            .add("ASO", super.getASO())
            .omitNullValues()
            .toString();
    }
}
