package common.ipdb.IPInfoIO;


import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.gson.Gson;
import common.ipdb.model.IPInfo;
import org.apache.http.HttpStatus;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;

public class IPInfoIOTools {
    private static final Logger logger = LoggerFactory.getLogger(IPInfoIOTools.class);
    private static final String IPINFOIO_BASE_URL = "http://ipinfo.io/%s/json";
    private static Gson gson = new Gson();

    private static Cache<String, IPInfoData> ipCache = CacheBuilder.newBuilder()
        .expireAfterAccess(12 * 60, TimeUnit.MINUTES) //12 hour
        .maximumSize(64 * 10000) // 640K
        .build();

    public static IPInfo getIPInfoData(String ip) {
        try {
            IPInfoData ipInfoData = ipCache.get(ip, new Callable<IPInfoData>() {
                @Override
                public IPInfoData call() {
                    return queryIPInfo(ip);
                }
            });

            IPInfo ipInfo = new IPInfo();
            ipInfo.setIp(ipInfoData.getIp());
            ipInfo.setCity(ipInfoData.getCity());
            ipInfo.setCountry(ipInfoData.getCountry());
            ipInfo.setLocation(ipInfoData.getLoc());
            ipInfo.setOrg(ipInfoData.getOrg());
            return ipInfo;
        } catch (Exception e) {
            logger.error("IP[{}] [{}]", ip, e.getMessage());
        }

        return null;
    }


    public static IPInfoData queryIPInfo(String ip) {
        try {
            String jsonStr = getUrlContent(String.format(IPINFOIO_BASE_URL, ip));
            return gson.fromJson(jsonStr, IPInfoData.class);
        } catch (Exception e) {
            return null;
        }
    }

    public static String getUrlContent(String url) throws Exception {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpGet httpget = new HttpGet(url);
        httpget.addHeader("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:29.0) Gecko/20100101 Firefox/29.0");
        CloseableHttpResponse response = httpClient.execute(httpget);
        try {
            if (response.getStatusLine().getStatusCode() == HttpStatus.SC_OK) {
                return EntityUtils.toString(response.getEntity());
            } else {
                return "";
            }

        } finally {
            response.close();
        }


    }
}
