/*
 * Decompiled with CFR 0.152.
 */
package common.ipdb.IPInfoIO;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.gson.Gson;
import common.ipdb.IPInfoIO.IPInfoData;
import common.ipdb.model.IPInfo;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IPInfoIOTools {
    private static final Logger logger = LoggerFactory.getLogger(IPInfoIOTools.class);
    private static final String IPINFOIO_BASE_URL = "http://ipinfo.io/%s/json";
    private static Gson gson = new Gson();
    private static Cache<String, IPInfoData> ipCache = CacheBuilder.newBuilder().expireAfterAccess(720L, TimeUnit.MINUTES).maximumSize(640000L).build();

    public static IPInfo getIPInfoData(final String ip) {
        try {
            IPInfoData ipInfoData = (IPInfoData)ipCache.get((Object)ip, (Callable)new Callable<IPInfoData>(){

                @Override
                public IPInfoData call() {
                    return IPInfoIOTools.queryIPInfo(ip);
                }
            });
            IPInfo ipInfo = new IPInfo();
            ipInfo.setIp(ipInfoData.getIp());
            ipInfo.setCity(ipInfoData.getCity());
            ipInfo.setCountry(ipInfoData.getCountry());
            ipInfo.setLocation(ipInfoData.getLoc());
            ipInfo.setOrg(ipInfoData.getOrg());
            return ipInfo;
        }
        catch (Exception e) {
            logger.error("IP[{}] [{}]", (Object)ip, (Object)e.getMessage());
            return null;
        }
    }

    public static IPInfoData queryIPInfo(String ip) {
        try {
            String jsonStr = IPInfoIOTools.getUrlContent(String.format(IPINFOIO_BASE_URL, ip));
            return (IPInfoData)gson.fromJson(jsonStr, IPInfoData.class);
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUrlContent(String url) throws Exception {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpGet httpget = new HttpGet(url);
        httpget.addHeader("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:29.0) Gecko/20100101 Firefox/29.0");
        try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpget);){
            if (response.getStatusLine().getStatusCode() == 200) {
                String string = EntityUtils.toString((HttpEntity)response.getEntity());
                return string;
            }
            String string = "";
            return string;
        }
    }
}

