/*
 * Decompiled with CFR 0.152.
 */
package common.ipdb.geoip;

import com.github.davidmoten.geo.GeoHash;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.maxmind.db.CHMCache;
import com.maxmind.db.NodeCache;
import com.maxmind.geoip2.DatabaseReader;
import com.maxmind.geoip2.exception.AddressNotFoundException;
import com.maxmind.geoip2.model.AsnResponse;
import com.maxmind.geoip2.model.CityResponse;
import com.maxmind.geoip2.record.City;
import com.maxmind.geoip2.record.Country;
import com.maxmind.geoip2.record.Location;
import com.maxmind.geoip2.record.Postal;
import common.ipdb.geoip.EGeoDBTypes;
import common.ipdb.model.IPASNInfo;
import common.ipdb.model.IPInfo;
import java.io.File;
import java.net.InetAddress;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoIpTools {
    private static final Logger logger = LoggerFactory.getLogger(GeoIpTools.class);
    private static Map<EGeoDBTypes, DatabaseReader> dbReaderMap = Maps.newHashMap();

    public static String getDefaultPath() {
        String os_name = System.getProperty("os.name").toLowerCase();
        if (os_name.contains("window")) {
            return "c:/valor/ipdb";
        }
        return "/valor/ipdb";
    }

    public static String getOrDefaultDBPath(EGeoDBTypes types, String dbPath) {
        if (Strings.isNullOrEmpty((String)dbPath)) {
            dbPath = String.format("%s/%s", GeoIpTools.getDefaultPath(), types.getName());
        }
        return dbPath;
    }

    public static void loadDB(EGeoDBTypes types, String dbName) {
        try {
            DatabaseReader reader = dbReaderMap.get((Object)types);
            if (reader != null) {
                reader.close();
            }
        }
        catch (Exception e) {
            logger.info("Reader close exeption:{}", (Throwable)e);
        }
        try {
            dbName = GeoIpTools.getOrDefaultDBPath(types, dbName);
            File dbFile = new File(dbName);
            if (!dbFile.exists()) {
                logger.info("DB[{}] not exist", (Object)dbFile);
            } else {
                DatabaseReader reader = new DatabaseReader.Builder(dbFile).withCache((NodeCache)new CHMCache()).build();
                dbReaderMap.put(types, reader);
                logger.info("DB[{}] is loaded", (Object)dbFile);
            }
        }
        catch (Exception e) {
            logger.error("DB[{}] load failed! ex[{}]", (Object)dbName, (Object)e);
        }
    }

    public static void loadFromDefaultPath() {
        for (EGeoDBTypes types : EGeoDBTypes.values()) {
            GeoIpTools.loadDB(types, "");
        }
    }

    public static IPInfo getCityInfo(String ip) {
        try {
            Postal postal;
            Location location;
            Country country;
            DatabaseReader reader = dbReaderMap.get((Object)EGeoDBTypes.GEOLITE2_CITY);
            if (reader == null) {
                return null;
            }
            InetAddress ipAddress = InetAddress.getByName(ip);
            CityResponse response = reader.city(ipAddress);
            if (response == null) {
                return null;
            }
            IPInfo ipInfo = new IPInfo();
            ipInfo.setIp(ip);
            City city = response.getCity();
            if (city != null) {
                ipInfo.setCity(city.getName());
            }
            if ((country = response.getCountry()) != null) {
                ipInfo.setCountry(Strings.nullToEmpty((String)country.getIsoCode()).toLowerCase());
            }
            if ((location = response.getLocation()) != null) {
                ipInfo.setLatitude(location.getLatitude());
                ipInfo.setLongitude(location.getLongitude());
                ipInfo.setLocation(String.format("%s,%s", location.getLatitude(), location.getLongitude()));
                String geoHash = GeoHash.encodeHash((double)location.getLatitude(), (double)location.getLongitude());
                ipInfo.setGeoHash(geoHash);
            }
            if ((postal = response.getPostal()) != null) {
                ipInfo.setPostCode(postal.getCode());
            }
            return ipInfo;
        }
        catch (Exception e) {
            GeoIpTools.printException(ip, e);
            return null;
        }
    }

    private static void printException(String ip, Exception e) {
        if (e instanceof AddressNotFoundException) {
            logger.warn("IP[{}] Not Found", (Object)ip, (Object)e.getMessage());
        } else {
            logger.error("IP[{}] message:[{}]", (Object)ip, (Object)e);
        }
    }

    public static IPASNInfo getASNInfo(String ip) {
        try {
            DatabaseReader reader = dbReaderMap.get((Object)EGeoDBTypes.GEOLITE2_ASN);
            if (reader == null) {
                return null;
            }
            InetAddress ipAddress = InetAddress.getByName(ip);
            AsnResponse response = reader.asn(ipAddress);
            if (response == null) {
                return null;
            }
            IPASNInfo asnInfo = new IPASNInfo();
            asnInfo.setASN(response.getAutonomousSystemNumber());
            asnInfo.setASO(response.getAutonomousSystemOrganization());
            return asnInfo;
        }
        catch (Exception e) {
            GeoIpTools.printException(ip, e);
            return null;
        }
    }

    public static IPInfo getIPInfo(String ip) {
        if (Strings.isNullOrEmpty((String)ip)) {
            return null;
        }
        if (dbReaderMap.isEmpty()) {
            return null;
        }
        try {
            IPASNInfo asnInfo;
            IPInfo info = GeoIpTools.getCityInfo(ip);
            if (info != null && (asnInfo = GeoIpTools.getASNInfo(ip)) != null) {
                info.setASN(asnInfo.getASN());
                info.setASO(asnInfo.getASO());
            }
            return info;
        }
        catch (Exception e) {
            logger.error("IP[{}] message:[{}]", (Object)ip, (Object)e.getMessage());
            return null;
        }
    }

    public static String getCountry(String ip) {
        IPInfo ipInfo = GeoIpTools.getCityInfo(ip);
        if (ipInfo == null) {
            return "";
        }
        return Strings.nullToEmpty((String)ipInfo.getCountry());
    }

    static {
        GeoIpTools.loadFromDefaultPath();
    }
}

