package common.ipdb.api.iphub;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import common.config.tools.config.ConfigTools3;
import common.ipdb.api.IIPDBApi;
import common.ipdb.httptool.HCTools;
import common.ipdb.httptool.HttpResponse;
import common.ipdb.model.IPInfo;
import org.apache.http.HttpStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Query info from iphub.info, 1000 request limit per day
 * !!!IMPORT:This Provider CANNOT be used in production environments.
 * <p>
 *
 * @see <a href="https://iphub.info">iphub.info</a>
 * @see <a href="https://docs.iphub.info/documentation">docs.iphub.info</a>
 */
public class IPHubApi implements IIPDBApi {
    private static final Logger logger = LoggerFactory.getLogger(IPHubApi.class);
    private static Gson gson = new Gson();

    public IPInfo query(String ip) {
        try {
            String apiUrlTpl = ConfigTools3.getString("ipdb.api.iphub.url", "http://v2.api.iphub.info/ip/%s");
            String apiAuthKey = ConfigTools3.getNonEmptyString("ipdb.api.iphub.key");

            ImmutableMap<String, String> headers = ImmutableMap.of("X-key", apiAuthKey);

            HttpResponse response = HCTools.get(String.format(apiUrlTpl, ip), headers);
            if (response.getStatus() == HttpStatus.SC_OK && !Strings.isNullOrEmpty(response.getBody())) {
                return gson.fromJson(response.getBody(), IPInfo.class);
            }

        } catch (Exception e) {
            logger.error("IP[{}]", ip, e);
            return null;
        }

        return null;
    }
}
