package common.ipdb.api.ipinfoio;

import com.google.common.base.Strings;
import com.google.gson.Gson;
import common.config.tools.config.ConfigTools3;
import common.ipdb.api.IIPDBApi;
import common.ipdb.httptool.HCTools;
import common.ipdb.httptool.HttpResponse;
import common.ipdb.model.IPInfo;
import org.apache.http.HttpStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Query info from ipinfo.io
 * !!!IMPORT:This Provider CANNOT be used in production environments.
 * <p>
 * @see <a href="https://ipinfo.io/developers">ipinfo.io</a>
 */
public class IPInfoIOApi implements IIPDBApi {
    private static final Logger logger = LoggerFactory.getLogger(IPInfoIOApi.class);
    private static Gson gson = new Gson();

    public IPInfo query(String ip) {
        try {
            String apiUrlTpl = ConfigTools3.getString("ipdb.api.ipinfo.url", "http://ipinfo.io/%s/json");
            HttpResponse response = HCTools.get(String.format(apiUrlTpl, ip), null);
            if (response.getStatus() == HttpStatus.SC_OK && !Strings.isNullOrEmpty(response.getBody())) {
                return gson.fromJson(response.getBody(), IPInfo.class);
            }

        } catch (Exception e) {
            logger.error("IP[{}]", ip, e);
            return null;
        }

        return null;
    }
}
