package common.ipdb.httptool;

import com.google.common.base.Strings;
import org.apache.http.HttpStatus;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

import java.util.Map;

public class HCTools {

    public static HttpResponse get(String url, Map<String, String> headers) throws Exception {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpGet httpget = new HttpGet(url);

        httpget.addHeader("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:29.0) Gecko/20100101 Firefox/29.0");
        if (headers != null) {
            headers.forEach((k, v) -> {
                if (!Strings.isNullOrEmpty(k)) {
                    httpget.addHeader(k, v);
                }
            });
        }

        HttpResponse httpResponse = new HttpResponse();
        CloseableHttpResponse response = httpClient.execute(httpget);
        httpResponse.setStatus(response.getStatusLine().getStatusCode());
        try {
            if (response.getStatusLine().getStatusCode() == HttpStatus.SC_OK) {
                httpResponse.setBody(EntityUtils.toString(response.getEntity()));
            } else {
                httpResponse.setBody("");
            }

        } finally {
            response.close();
        }
        return httpResponse;
    }
}
