package common.ipdb.model;

import com.google.common.base.MoreObjects;
import com.google.gson.annotations.SerializedName;

/**
 * IP information
 */
public class IPInfo extends IPASNInfo {
    /**
     * IP address
     */
    private String ip; //ip
    private String city; //city name
    private String region;

    //country code ISO 3166 Alpha-2 Code
    @SerializedName(value = "country", alternate = {"countryCode"})
    private String country;

    private double latitude;
    private double longitude;
    private String geoHash;


    @SerializedName(value = "location", alternate = {"loc"})
    private String location; //location
    private String postCode;
    /**
     * ISP name of the IP address
     * ipinfoio: use org
     * iphub: use asn
     */
    @SerializedName(value = "isp", alternate = {"org"})
    private String isp;

    /**
     * Reverse DNS of the IP address (temporarily disabled)
     */
    private String hostname;

    /**
     * As some Autonomous Systems resell IP prefixes to third party organisations, we provide the block parameter so you can determine your own ‘risk-level.’
     * "block":0 - Residential / Unclassified IP address
     * "block":1 - Non-residential IP address (server, VPN, proxy, etc..)
     * "block":2 - Non-residential & Residential (Warning: may flag innocent people)
     */
    private int block;

    public String getIsp() {
        return isp;
    }

    public void setIsp(String isp) {
        this.isp = isp;
    }

    public String getHostname() {
        return hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getRegion() {
        return region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getCountry() {
        return country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public double getLatitude() {
        return latitude;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public double getLongitude() {
        return longitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public String getGeoHash() {
        return geoHash;
    }

    public void setGeoHash(String geoHash) {
        this.geoHash = geoHash;
    }

    public String getLocation() {
        return location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getPostCode() {
        return postCode;
    }

    public void setPostCode(String postCode) {
        this.postCode = postCode;
    }

    public String getOrg() {
        return isp;
    }

    public void setOrg(String org) {
        this.isp = org;
    }

    public int getBlock() {
        return block;
    }

    public void setBlock(int block) {
        this.block = block;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
            .add("ip", ip)
            .add("city", city)
            .add("region", region)
            .add("country", country)
            .add("latitude", latitude)
            .add("longitude", longitude)
            .add("geoHash", geoHash)
            .add("location", location)
            .add("postCode", postCode)
            .add("isp", isp)
            .add("hostname", hostname)
            .add("block", block)
            .add("ASN", getASN())
            .add("ASO", getASO())
            .toString();
    }
}
