/*
 * Decompiled with CFR 0.152.
 */
package common.ipdb.api;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import common.config.tools.config.ConfigTools3;
import common.ipdb.api.IIPDBApi;
import common.ipdb.api.geoip.GroIPApi;
import common.ipdb.model.IPInfo;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IPDBTools {
    private static final Logger logger = LoggerFactory.getLogger(IPDBTools.class);
    private static IIPDBApi ipQueryProvider;
    private static Cache<String, IPInfo> ipCache;

    public static void registerQueryProvider(IIPDBApi iIpQueryProvider) {
        if (ipQueryProvider != null) {
            ipQueryProvider = iIpQueryProvider;
        }
    }

    public static IPInfo get(final String ip) {
        try {
            IPInfo ipInfo = (IPInfo)ipCache.get((Object)ip, (Callable)new Callable<IPInfo>(){

                @Override
                public IPInfo call() {
                    if (Objects.isNull(ipQueryProvider)) {
                        ipQueryProvider = new GroIPApi();
                    }
                    return ipQueryProvider.query(ip);
                }
            });
            return ipInfo;
        }
        catch (Exception e) {
            logger.error("IP[{}] [{}]", (Object)ip, (Object)e.getMessage());
            return null;
        }
    }

    static {
        ipCache = CacheBuilder.newBuilder().expireAfterAccess((long)ConfigTools3.getInt((String)"ipdb.cache.expire.time", (Integer)720).intValue(), TimeUnit.MINUTES).maximumSize((long)ConfigTools3.getInt((String)"ipdb.cache.max.size", (Integer)640000).intValue()).build();
    }
}

