package common.ipdb.api.geoip;

public enum EGeoIPDBType {
    //city
    GEOLITE2_CITY("GeoLite2-City", "mmdb"),

    //asn
    GEOLITE2_ASN("GeoLite2-ASN", "mmdb"),

    //GeoIP2-Anonymous-IP
    //GEOLITE2_ANONYMOUS_IP("GeoIP2-Anonymous-IP", "mmdb"),
    ;

    EGeoIPDBType(String type, String suffix) {
        this.type = type;
        this.suffix = suffix;
    }

    private String type;
    private String suffix;

    public String getType() {
        return type;
    }

    public String getSuffix() {
        return suffix;
    }

    public String getName() {
        return String.format("%s.%s", type, suffix);
    }
}
